﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Timers;
using System.Runtime.InteropServices;

namespace Azyobuzi.りすにんぐついったー
{
    public class iTunesListener:IMusicDataListener
    {
        private Timer LoopTimer = new Timer(1000D);
        public event EventHandler<ListeningMusicChangedEventArgs> ListeningMusicChanged;
        public dynamic iTunes = null;

        private ListeningMusicChangedEventArgs old;

        public iTunesListener()
        {
            iTunes = Activator.CreateInstance(Type.GetTypeFromProgID("iTunes.Application", true));
            LoopTimer.Elapsed+=new ElapsedEventHandler(timer_Elapsed);
        }

        private void timer_Elapsed(object sender, ElapsedEventArgs e){
            dynamic track = null;
            try {
                track = iTunes.CurrentTrack;
                if (track == null) {
                    OnListeningMusicChanged(null);
                    old = null;
                    return;
                }

                string title = track.Name;
                string artist = track.Artist;
                string album = track.Album;

                if (old == null || old.Title != title || old.Artist != artist || old.Album != album) {
                    var args = new ListeningMusicChangedEventArgs(title, artist, album);
                    OnListeningMusicChanged(args);
                    old = args;
                }
            }
            catch(COMException)
            {
                if (!Program.m_form.BalloonTipVisible)
                {
                    Program.m_form.notifyIcon1.ShowBalloonTip(0, "", "iTunesとの通信に失敗しました。でも気にしないで♪", System.Windows.Forms.ToolTipIcon.None);
                }
            } finally {
                if (track != null) {
                    Marshal.FinalReleaseComObject(track);
                }
            }
        }

        protected void OnListeningMusicChanged(ListeningMusicChangedEventArgs e)
        {
            if (this.ListeningMusicChanged != null)
            {
                this.ListeningMusicChanged(this, e);
            }
        }


        public bool Enable 
        {
            get 
            {
                return this.LoopTimer.Enabled;
            }
            set 
            {
                this.LoopTimer.Enabled = value;
            }
        }

        public void Start() 
        {
            this.LoopTimer.Start();
        }

        public void Stop() 
        {
            this.LoopTimer.Stop();
        }

        public void Dispose() 
        {
            this.LoopTimer.Dispose();
            if (this.iTunes != null) {
                Marshal.FinalReleaseComObject(this.iTunes);
            }
        }
    }
}
